package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка фильтрации по OriginalUrl и по PreviewUrl")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesUrlTest {
    private static String client = AdImagesLogins.CLIENT_GET_9;
    private String hash;
    private GetResponse response;
    private static String x90 = "x90";
    private static String wx300 = "wx300";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public ImageType inputConfigType;

    @Parameterized.Parameter(2)
    public String outputUrl;

    @Parameterized.Parameters(name = "imageType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"regular", ImageType.REGULAR, x90},
                {"wide", ImageType.WIDE, wx300}

        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
            hash = api.userSteps.imagesSteps().configLoginImages(client, inputConfigType, 1)[0];
            response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(hash)
                        )
                        .withFieldNames(AdImageFieldEnum.ORIGINAL_URL, AdImageFieldEnum.PREVIEW_URL)
            );
            assumeThat("веррнулась 1 картинка", response.getAdImages(), hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2439")
    public void getExpectedOriginalUrlTest() {
        assertThat("вернулись ожидаемые OriginalUrl картинок",
                response.getAdImages().get(0).getOriginalUrl().getValue().contains(hash), equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2438")
    public void getExpectedPreviewUrlTest() {
        assertThat("вернулись ожидаемые PreviewUrl картинок",
                response.getAdImages().get(0).getPreviewUrl().getValue().contains(hash +"/"+ outputUrl), equalTo(true));
    }
}
