package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesPoolRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by proxeter on 24.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8804
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка корректного получения AdImages когда в базе значение для name равно null или пустой строке")
@Issue("https://st.yandex-team.ru/DIRECT-52142")
@RunWith(Parameterized.class)
public class AdImagesWithNullNameInDBTest {

    private static String client = AdImagesLogins.CLIENT_GET_11;
    private String imageHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String dbName;

    @Parameterized.Parameter(value = 1)
    public String responseName;

    @Parameterized.Parameters(name = "dbName = {0}, responseName = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {null, ""},
                {"", ""}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        imageHash = api.userSteps.imagesStepsV5().addDefaultRegularAdImage();

        Integer shardId = api.userSteps.clientFakeSteps().getUserShard(client);
        Long clientId = Long.valueOf(api.userSteps.clientFakeSteps().getClientData(client).getClientID());

        DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shardId);
        BannerImagesPoolRecord bannerImagesPoolRecord =
                directJooqDbSteps.bannerImagesPoolSteps().getBannerImagesPool(clientId, imageHash);
        bannerImagesPoolRecord.setName(null);
        directJooqDbSteps.bannerImagesPoolSteps().updateBannerImagesPool(clientId, bannerImagesPoolRecord);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2440")
    public void adImagesWithEmptyOrNullNameInDB() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(imageHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH, AdImageFieldEnum.NAME)
        );

        AdImageGetItem adImage =
                (AdImageGetItem) new AdImageGetItemMap()
                        .withAdImageHash(imageHash)
                        .withName(responseName)
                        .getBean();

        assertThat(
                "вернулась правильная картинка",
                response.getAdImages(),
                beanDiffer(Collections.singletonList(adImage))
        );
    }
}
