package ru.yandex.autotests.direct.api.ads;

import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class AccessRightsErrorHelper {
    public static void checkCatchingJavaError54(Api5Error expectedError, Runnable test) {
        try {
            test.run();
        } catch (Api5JsonError jsonError) {
            // Java версия сервиса возвращает 54-ю ошибку на весь запрос
            if (expectedError == null) {
                throw new AssertionError("неожиданная ошибка", jsonError);
            }
            assertThat("совпал текст ошибки (JSON)", jsonError,
                    Api5JsonErrorMatcher.equalToIgnoreLocale(expectedError.toJsonError()));
        }
    }
}
