package ru.yandex.autotests.direct.api.ads;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsDeadDomainsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppcdict.tables.records.DomainsDictRecord;
import ru.yandex.autotests.direct.db.steps.BsDeadDomainsSteps;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.DomainsSteps;

public class BsDeadDomainsHelper {
    public static void addToBsDeadDomains(int shard, DirectJooqDbSteps directJooqDbSteps, String deadDomain) {
        DomainsDictRecord domainsDictRecord =
                directJooqDbSteps.domainsDictSteps().getDomainsDictRecord(deadDomain);
        if (domainsDictRecord == null) {
            domainsDictRecord = directJooqDbSteps.domainsDictSteps()
                    .createDomain(new DomainsDictRecord().setDomain(deadDomain));
        }
        DomainsSteps domainsSteps = directJooqDbSteps.useShard(shard).domainsSteps();
        if (domainsSteps.getDomain(domainsDictRecord.getDomain()) == null) {
            domainsSteps.createDomain(domainsDictRecord.getDomainId(), domainsDictRecord.getDomain());
        }
        BsDeadDomainsSteps bsDeadDomainsSteps = directJooqDbSteps.useShard(shard).bsDeadDomainsSteps();
        if (bsDeadDomainsSteps.getBsDeadDomain(domainsDictRecord.getDomainId()) == null) {
            BsDeadDomainsRecord bsDeadDomain = new BsDeadDomainsRecord().setDomainId(domainsDictRecord.getDomainId());
            bsDeadDomainsSteps.createBsDeadDomains(bsDeadDomain);
        }
    }

    public static void removeFromBsDeadDomains(int shard, DirectJooqDbSteps directJooqDbSteps, String aliveDomain) {
        Long domainId = directJooqDbSteps.domainsDictSteps().getDomainId(aliveDomain);
        if (domainId != null) {
            directJooqDbSteps.useShard(shard).bsDeadDomainsSteps().deleteBsDeadDomains(domainId);
        }
    }
}
