package ru.yandex.autotests.direct.api.ads;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.campaigns.CampaignStepsV5;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by hmepas on 14.10.16.
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Чистим кампании пользователей")
@RunWith(Parameterized.class)
public class ClearCampaigns {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"test-client-banner"}
        };
        return Arrays.asList(data);
    }

    @Test
    @Ignore
    public void clearUserCampaigns() {
        final CampaignStepsV5 campaignSteps = api.as(login).userSteps.campaignSteps();
        final List<CampaignGetItem> campaigns = campaignSteps.getCampaigns(
                new GetRequestMap().withFieldNames(CampaignFieldEnum.ID)
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()));
        campaignSteps.campaignsDelete(campaigns.stream().map(i -> i.getId()).limit(999).toArray(Long[]::new));
    }

}
