package ru.yandex.autotests.direct.api.ads;

import java.util.Arrays;
import java.util.function.Supplier;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Description("Создать объявление в группе запрещённого в апи типа")
@Issue("https://st.yandex-team.ru/DIRECT-99031")
@RunWith(Parameterized.class)
public class ModifyAdForbiddenTypeTest {

    private static String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public BannersBannerType bannerType;

    @Parameterized.Parameter(1)
    public PhrasesAdgroupType adGroupType;

    @Parameterized.Parameter(2)
    public Supplier<AdAddItemMap> adAddItemMapBuilder;

    @Parameterized.Parameter(3)
    public Supplier<AdUpdateItemMap> adUpdateItemMapBuilder;

    @Parameterized.Parameters(name = "bannerType = {0}, adGroupType ={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {BannersBannerType.cpm_banner, PhrasesAdgroupType.cpm_geoproduct,
                        (Supplier<AdAddItemMap>) () -> new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap()
                                        .withHref("https://yandex.ru")
                                        .withCreative(html5CreativeId)),
                        (Supplier<AdUpdateItemMap>) () -> new AdUpdateItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdUpdateMap()
                                        .withHref("https://yandex.ru"))},
                {BannersBannerType.cpm_outdoor, PhrasesAdgroupType.cpm_outdoor,
                        (Supplier<AdAddItemMap>) () -> new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap()
                                        .withHref("https://yandex.ru")
                                        .withCreative(html5CreativeId)),
                        (Supplier<AdUpdateItemMap>) () -> new AdUpdateItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdUpdateMap()
                                        .withHref("https://yandex.ru"))}
        });
    }

    private static Long adGroupId;
    private static Long adId;
    private static Long html5CreativeId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).adGroupsSteps().setType(adGroupId, adGroupType);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersSteps().setBannersBannerType(adId,
                bannerType);
        html5CreativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .perfCreativesSteps()
                .saveDefaultHtml5CreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));
    }

    @After
    public void after() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).adGroupsSteps().setType(adGroupId,
                PhrasesAdgroupType.base);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersSteps().setBannersBannerType(adId,
                BannersBannerType.text);
    }

    @Test
    public void testAdd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(adAddItemMapBuilder.get()),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.ADGROUP_NOT_SUPPORTED)));
    }

    @Test
    public void testUpdate() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(adUpdateItemMapBuilder.get()),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testModerate() {
        api.userSteps.adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testResume() {
        api.userSteps.adsSteps().shouldGetResultOnResume(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testSuspend() {
        api.userSteps.adsSteps().shouldGetResultOnSuspend(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testArchive() {
        api.userSteps.adsSteps().shouldGetResultOnArchive(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testUnarchive() {
        api.userSteps.adsSteps().shouldGetResultOnUnarchive(
                new IdsCriteriaMap().withIds(adId),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }

    @Test
    public void testDelete() {
        api.userSteps.adsSteps().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.AD_NOT_SUPPORTED)));
    }
}
