package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Группы cpm_banner не поддерживаются")
@Issue("https://st.yandex-team.ru/DIRECT-69268")
@RunWith(Parameterized.class)
public class AddAdCpmBannerAdGroupTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "bannerType = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {BannerType.TEXT},
                {BannerType.MOBILE_CONTENT},
                {BannerType.DYNAMIC}
        });
    }

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, PhrasesAdgroupType.cpm_banner);
    }

    @Test
    public void addAdToCpmBannerGroup() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withDefaultAd(bannerType)),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP))
        );
    }
}
