package ru.yandex.autotests.direct.api.ads.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesPoolRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by hmepas on 20.08.16.
 * https://st.yandex-team.ru/TESTIRT-10105
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка привязки к баннеру картники с name = NULL в БД")
@Issue("https://st.yandex-team.ru/DIRECT-57319")
public class AddAdWithNullNameImageTest {
    public static final String LOGIN = AdsLogins.CLIENT49;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void assigningImageWithNullNameWorks() {
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        final DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        jooqDbSteps.useShardForLogin(LOGIN);

        /* Заливаем картинку и обнуляем ее имя в БД */
        final String regularAdImageHash = api.userSteps.imagesStepsV5().addDefaultRegularAdImage();
        final BannerImagesPoolRecord nullNameImage = jooqDbSteps.bannerImagesPoolSteps()
                .getBannerImagesPool(clientId, regularAdImageHash);
        nullNameImage.setName(null);
        jooqDbSteps.bannerImagesPoolSteps().updateBannerImagesPool(clientId, nullNameImage);

        /* Проверяем что изображение с name=null можно привязать к баннеру (не падаем его получении из БД) */
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(regularAdImageHash))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
    }
}
