package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 05.10.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Создать текстовое объявление я в группе неподходящего типа")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@RunWith(Parameterized.class)
public class AddAdWrongAdGroupTypeTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "adGroupType = {1}, bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.TEXT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.MOBILE_CONTENT},
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.MOBILE_CONTENT},
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.DYNAMIC},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.DYNAMIC},
        });
    }

    private static long adGroupId;

    @BeforeClass
    public static void createCampaignWithAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void setAdGroupType() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
    }

    @Test
    public void addTextAdToNonTextAdGroup() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withDefaultAd(bannerType)),
                ExpectedResult.errors(new Notification(
                        6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)));
    }
}
