package ru.yandex.autotests.direct.api.ads.add;

import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;

/**
 * Created by semkagtn on 26.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Запросы на добавление объвления с указанием нескольких типов")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
public class AddOneAdMoreThanOneTypeTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Добавить объявление, указав в запросе два типа: текстовое и рекламу мобильных приложений")
    public void textAndMobileAppTypes() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                        .withAdGroupId(666L)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd())
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd())),
                adMustContainOnlyOneOfTheObjects());
    }

    @Test
    @Description("Добавить объявление, указав в запросе два типа: текстовое и динамическое текстовое")
    public void textAndDynamicTextTypes() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                        .withAdGroupId(666L)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd())
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd())),
                adMustContainOnlyOneOfTheObjects());
    }

    @Test
    @Description("Добавить объявление, указав в запросе два типа: рекламу мобильных приложений и динамическое текстовое")
    public void mobileAppAndDynamicTextTypes() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                        .withAdGroupId(666L)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd())
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd())),
                adMustContainOnlyOneOfTheObjects());
    }

    @Test
    @Description("Добавить объявление, указав в запросе три типа: текстовое, динамическое текстовое и рекламу мобильных приложений")
    public void textAndDynamicTextAndMobileAppTypes() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                        .withAdGroupId(666L)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd())
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd())
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd())),
                adMustContainOnlyOneOfTheObjects());
    }

    private static JavaOrPerlExpectedResult adMustContainOnlyOneOfTheObjects() {
        return JavaOrPerlExpectedResult
                .java(ExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        allAdTypesCommaSeparatedAndCapitalized())))
                .perl(ExpectedResult.errors(new Notification(5009,
                        Api5ErrorDetails.AD_MUST_CONTAIN_ONLY_ONE_OF_THE_OBJECTS)));
    }

    private static String allAdTypesCommaSeparatedAndCapitalized() {
        //перечень названий типов должен соответствовать типам в
        // ru.yandex.direct.api.v5.entity.ads.validation.AdTypeNames
        return Stream.of(
                AdAddItemMap.TEXT_AD, AdAddItemMap.DYNAMIC_TEXT_AD, AdAddItemMap.MOBILE_APP_AD,
                AdAddItemMap.TEXT_IMAGE_AD, AdAddItemMap.MOBILE_APP_IMAGE_AD, AdAddItemMap.TEXT_AD_BUILDER_AD,
                AdAddItemMap.MOBILE_APP_AD_BUILDER_AD, AdAddItemMap.CPM_BANNER_AD_BUILDER_AD,
                AdAddItemMap.CPC_VIDEO_AD_BUILDER_AD, AdAddItemMap.CPM_VIDEO_AD_BUILDER_AD,
                "ContentPromotionVideoAd", "ContentPromotionCollectionAd", "ContentPromotionServiceAd",
                "ContentPromotionEdaAd", "smartAdBuilderAd", "MobileAppCpcVideoAdBuilderAd")
                .map(StringUtils::capitalize).collect(joining(", "));
    }

}
