package ru.yandex.autotests.direct.api.ads.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Несколько типов типа в одном AdAddItem")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class AddTwoTypesInRequestTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    static Long mobileAppCampaignId;
    static Long mobileAppAdGroupId;

    static Long dynamicTextCampaignId;
    static Long dynamicTextAdGroupId;

    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);

        dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);

        DirectJooqDbSteps dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);
        creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));
    }

    @Test
    public void addTextAdAndMobileAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd())
                                .withAdGroupId(adGroupId),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId)), ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addMobileAdAndTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultMobileAd())
                                .withAdGroupId(adGroupId),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd())
                                .withAdGroupId(adGroupId)), ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addMobileAppAdAndTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()),
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd())),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addTextAndMobileAppAndDynamicTextAds() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()),
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()),
                new AdAddItemMap()
                        .withAdGroupId(dynamicTextAdGroupId)
                        .withDynamicTextAd(new DynamicTextAdAddMap()
                                .defaultDynamicTextAd())),
                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());
    }


    @Test
    public void addTextAdBuilderAndMobileAppAdBuilderAds() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withTextAdBuilderAd(new TextAdBuilderAdAddMap()
                                .defaultTextAdBuilderAd(creativeId)),
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAdBuilderAd(new MobileAppAdBuilderAdAddMap()
                                .defaultMobileAppAdBuilderAd(creativeId))),
                ExpectedResult.success(), ExpectedResult.success());
    }
}
