package ru.yandex.autotests.direct.api.ads.add;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 23.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("проверка SOAP")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class AdsAddSOAPTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).protocol(ProtocolType.SOAP).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String ADD_REQUEST = "AddRequest";

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void successAdTest() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd().withTitle2(TextAdAddMap.DEFAULT_TITLE_2))
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
    }

    @Test
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(AddRequestMap.ADS)));
    }

    @Test
    public void requestWithoutText() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withHref(TextAdAddMap.DEFAULT_HREF)
                                        .withMobile(YesNoEnum.NO))
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_VALUE_OR_NULL,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.TEXT))
                                        .collect(joining("."))));
    }

    @Test
    public void requestWithoutTitle() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withHref(TextAdAddMap.DEFAULT_HREF)
                                        .withMobile(YesNoEnum.NO))
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_VALUE_OR_NULL,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.TITLE))
                                        .collect(joining("."))));
    }
}
