package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 23.05.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка прав доступа агентства к AdImageHash")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToAdImageHashTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT4;
    private static String agency = AdsLogins.AGENCY;
    private static String agencyRep = AdsLogins.AGENCY_REP;
    private static String agencyRepCl = AdsLogins.AGENCY_REP_CL;
    private static String subclient = AdsLogins.SUBCLIENT;
    private static String subclientElse = AdsLogins.SUBCLIENT_ELSE;

    private static String clientAdImageHash;
    private static String subclientAdImageHash;
    private static String subclientElseAdImageHash;
    static Long adGroupId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
        api.as(client);
        clientAdImageHash = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1)[0];
        api.as(agency);
        Long subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        subclientAdImageHash = api.userSteps.imagesSteps().configLoginImages(subclient, ImageType.REGULAR, 2)[0];
        subclientElseAdImageHash = api.userSteps.imagesSteps().configLoginImages(subclientElse, ImageType.REGULAR, 3)[0];
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
    }

    @Test
    public void callAddWithSubclientAdImageHash() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(subclientAdImageHash))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success()
        );
    }

    @Test
    public void callAddWithSubclientElseAdImageHash() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(subclientElseAdImageHash))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND))
        );
    }

    @Test
    public void callAddWithAdImageHashesOfBothSubclients() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(subclientAdImageHash))
                                .withAdGroupId(adGroupId),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(subclientElseAdImageHash))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND))
        );
    }

    @Test
    public void callAddWithClientAdImageHash() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withAdImageHash(clientAdImageHash))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND))
        );
    }
}
