package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка прав доступа агентства к SitelinkSetId")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToSitelinkSetIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT;
    private static String agency = AdsLogins.AGENCY;
    private static String agencyRep = AdsLogins.AGENCY_REP;
    private static String agencyRepCl = AdsLogins.AGENCY_REP_CL;
    private static String subclient = AdsLogins.SUBCLIENT;
    private static String subclientElse = AdsLogins.SUBCLIENT_ELSE;

    private static Long clientSitelinkSetId;
    private static Long subclientSitelinkSetId;
    private static Long subclientElseSitelinkSetId;
    static Long adGroupId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
        api.as(client);
        clientSitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        api.as(agency);
        subclientSitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(subclient, 1);
        subclientElseSitelinkSetId =
                api.userSteps.sitelinksSteps().addDefaultSet(subclientElse, 1);
        Long subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
    }

    @Test
    public void callAddWithSubclientSitelinkSetId() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(subclientSitelinkSetId))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success()
        );
    }

    @Test
    public void callAddWithSubclientElseSitelinkSetId() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(subclientElseSitelinkSetId))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND))
        );
    }

    @Test
    public void callAddWithSitelinkSetIdsOfBothSubclients() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(subclientSitelinkSetId))
                                .withAdGroupId(adGroupId),
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(subclientElseSitelinkSetId))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success(),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND))
        );
    }

    @Test
    public void callAddWithClientSitelinkSetId() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(clientSitelinkSetId))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND))
        );
    }
}
