package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка ограничений на количество баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class AmountOfAdsRestrictionTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void add10001Ads() {
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[AddRequestMap.MAX_AMOUNT_OF_ADS_IN_REQUEST + 1];
        Arrays.fill(adAddItemMaps, new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd()).withAdGroupId(adGroupId));
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                new AddRequestMap().withAds(adAddItemMaps),
                new Api5Error(9300,
                        Api5ErrorDetails.ADD_NO_MORE_THAN_ADS, AddRequestMap.MAX_AMOUNT_OF_ADS_IN_REQUEST)
        );
    }

    @Test
    public void add51AdsInOneGroup() {
        //DIRECT-41098
        AdAddItemMap[] adAddItemMaps = new AdAddItemMap[AddRequestMap.MAX_AMOUNT_OF_ADS_IN_GROUP];
        Arrays.fill(adAddItemMaps, new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd()).withAdGroupId(adGroupId));
        ExpectedResult[] expectedResults = new ExpectedResult[AddRequestMap.MAX_AMOUNT_OF_ADS_IN_GROUP];
        Arrays.fill(expectedResults, ExpectedResult.success());
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(adAddItemMaps), expectedResults);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                        new AdAddItemMap().withTextAd(
                                new TextAdAddMap().defaultTextAd()).withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(7001, Api5ErrorDetailsJava.MAXIMUM_NUMBER_OF_ADS_IN_GROUP_REACHED)));
    }
}
