package ru.yandex.autotests.direct.api.ads.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Description("Проверка прав доступа к объектам сублиента с двумя агентствами")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class CheckRightsToObjectsOfClientWithDifferentOwnersTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String subclient = AdsLogins.SUBCLIENT_TWO_AGENCIES;
    private static String agency = AdsLogins.AGENCY;
    private static String secondOwner = AdsLogins.AGENCY_SHARD2;

    static Long adGroupId;
    static Long adGroupIdSecondOwner;
    static Long vCardId;
    static Long vCardIdSecondOwner;
    static Long sitelinkSetId;
    static Long sitelinkSetIdSecondOwner;

    @BeforeClass
    public static void createNotMineCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(secondOwner);
        api.as(agency);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, subclient);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(subclient, campaignId);
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(subclient, 1);
        //ToDo пока здесь, до выяснения правильного поведения
        sitelinkSetIdSecondOwner = api.userSteps.sitelinksSteps().addDefaultSet(subclient, 1);
        api.as(secondOwner);
        Long campaignIdSecondOwner = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        adGroupIdSecondOwner = api.userSteps.adGroupsSteps().addDefaultGroup(campaignIdSecondOwner, subclient);
        vCardIdSecondOwner = api.userSteps.vCardsSteps().addDefaultVCard(subclient, campaignIdSecondOwner);
    }


    @Test
    public void callAddWithAdGroupIdOfFirstOwner() {
        api.as(agency).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap()
                                                .defaultTextAd()
                                )
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success()
        );
    }

    @Test
    public void callAddWithAdGroupIdOfSecondOwner() {
        api.as(agency).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap()
                                                .defaultTextAd()
                                )
                                .withAdGroupId(adGroupIdSecondOwner)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.GROUP_NOT_FOUND))
        );
    }

    @Test
    public void callAddWithSitelinkSetIdOfFirstOwner() {
        api.as(agency).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(sitelinkSetId))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.success()
        );
    }

    @Test
    public void callAddWithSitelinkSetIdOfSecondOwner() {
        //DIRECT-42164
        //
        api.as(secondOwner).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(sitelinkSetIdSecondOwner))
                                .withAdGroupId(adGroupIdSecondOwner)
                ),
                subclient,
                ExpectedResult.success()
        );
        //
        api.as(agency).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap()
                                .withTextAd(new TextAdAddMap().defaultTextAd().withSitelinkSetId(sitelinkSetIdSecondOwner))
                                .withAdGroupId(adGroupId)
                ),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.SITELINKS_SET_NOT_FOUND))
        );
    }
}
