package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.google.common.primitives.Longs.asList;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Создание баннера с полным набором полей")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class FullRequestTest {

    private static String client = AdsLogins.CLIENT6;
    private static Long businessId = 1084861587L;
    private static YesNoEnum preferVCardOverBusiness = YesNoEnum.NO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long vCardId;
    private static Long sitelinkSetId;
    private static String adImageHash;
    private static Long adExtensionId;
    private static Long turboPageId;
    @BeforeClass
    public static void initTest() {
        DirectJooqDbSteps jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        long clientId = jooqSteps.usersSteps().getUser(client).getClientid();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        adImageHash = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1)[0];
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        turboPageId = jooqSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
    }

    @AfterClass
    public static void deleteTurboPages() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).turboLandingsSteps()
                .deleteTurboLandings(asList(turboPageId));
    }

    @Test
    public void addAdAndCheckSave() {
        //DIRECT-41119
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .defaultTextAd()
                                        .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                                        .withVCardId(vCardId)
                                        .withAdImageHash(adImageHash)
                                        .withSitelinkSetId(sitelinkSetId)
                                        .withAdExtensionIds(adExtensionId)
                                        .withTurboPageId(turboPageId)
                                        .withBusinessId(businessId)
                                        .withPreferVCardOverBusiness(preferVCardOverBusiness)
                                )
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_GROUP_ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.TEXT,
                        TextAdFieldEnum.TITLE,
                        TextAdFieldEnum.TITLE_2,
                        TextAdFieldEnum.HREF,
                        TextAdFieldEnum.V_CARD_ID,
                        TextAdFieldEnum.AD_IMAGE_HASH,
                        TextAdFieldEnum.SITELINK_SET_ID,
                        TextAdFieldEnum.AD_EXTENSIONS,
                        TextAdFieldEnum.TURBO_PAGE_ID,
                        TextAdFieldEnum.BUSINESS_ID,
                        TextAdFieldEnum.PREFER_V_CARD_OVER_BUSINESS)
        );
        assertThat("объявление сохранилось верно", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id).withAdGroupId(adGroupId)
                        .withTextAd(
                                new TextAdGetMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                                        .withHref(TextAdAddMap.DEFAULT_HREF)
                                        .withVCardId(vCardId)
                                        .withAdImageHash(adImageHash)
                                        .withSitelinkSetId(sitelinkSetId)
                                        .withTurboPageId(turboPageId)
                                        .withBusinessId(businessId)
                                        .withPreferVCardOverBusiness(preferVCardOverBusiness)
                                        .withAdExtensions(new AdExtensionAdGetItemMap()
                                                .withAdExtensionId(adExtensionId)
                                                .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }
}
