package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AccessRightsErrorHelper;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка внутренних ролей")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class InternalRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String servClient = AdsLogins.SERV_CLIENT;

    static int shard;

    @Parameter(0)
    public String loginForAuthorization;

    @Parameter(1)
    public ExpectedResult expectedResult;

    @Parameter(2)
    public Api5Error expectedError;

    @Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, ExpectedResult.success(), null},
                {Logins.PLACER,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPPORT, ExpectedResult.success(), null},
                {Logins.SUPER_LOGIN, ExpectedResult.success(), null},
                {Logins.MEDIA,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_READER,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(servClient);
        shard = api.userSteps.clientFakeSteps().getUserShard(servClient);
    }

    @Test
    public void checkRightsToAddTextAd() {
        AccessRightsErrorHelper.checkCatchingJavaError54(expectedError, () -> {
            Long campaignId =
                    api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultTextCampaign(servClient);
            Long adGroupId = api.as(servClient).userSteps.adGroupsSteps().addDefaultGroup(campaignId);
            api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                    new AddRequestMap().withAds(
                            new AdAddItemMap()
                                    .withTextAd(
                                            new TextAdAddMap()
                                                    .defaultTextAd()
                                                    .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                                    )
                                    .withAdGroupId(adGroupId)
                    ),
                    servClient,
                    expectedResult
            );
        });
    }

    @Test
    public void checkRightsToAddDynamicTextAd() {
        AccessRightsErrorHelper.checkCatchingJavaError54(expectedError, () -> {
            Long campaignId =
                    api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultDynamicTextCampaign(servClient);
            Long adGroupId = api.as(servClient).userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
            api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                    new AddRequestMap().withAds(
                            new AdAddItemMap()
                                    .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                    .withAdGroupId(adGroupId)
                    ),
                    servClient,
                    expectedResult
            );
        });
    }

    @Test
    public void checkRightsToAddMobileAppAd() {
        AccessRightsErrorHelper.checkCatchingJavaError54(expectedError, () -> {
            Long campaignId =
                    api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultMobileAppCampaign(servClient);
            Long adGroupId = api.as(servClient).userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
            api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnAdd(
                    new AddRequestMap().withAds(
                            new AdAddItemMap()
                                    .withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd())
                                    .withAdGroupId(adGroupId)
                    ),
                    servClient,
                    expectedResult
            );
        });
    }
}
