package ru.yandex.autotests.direct.api.ads.add;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Неправильный формат запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class InvalidJSONTest {
    //DIRECT-43203
    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean());
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(AddRequestMap.ADS, new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(AddRequestMap.ADS)));
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean());
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT));
    }

    @Test
    public void notArrayInAds() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean());
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), ad);
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY, path(AddRequestMap.ADS)));
    }

    @Test
    public void arrayInElementOfAds() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean());
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{new Object[]{ad}});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_VALUE,
                        path(AddRequestMap.ADS)));
    }

    @Test
    public void arrayInTextAd() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new Object[]{new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean()});
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(AddRequestMap.ADS, AdAddItemMap.TEXT_AD)));
    }

    @Test
    public void invalidFieldInAds() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(AdAddItemMap.TEXT_AD, new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF).getBean());
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        path(AddRequestMap.ADS), AdAddItemMap.TEXT_AD));
    }

    @Test
    public void invalidFieldInTextAd() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(TextAdAddMap.TEXT, TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(TextAdAddMap.TEXT)));
    }
}
