package ru.yandex.autotests.direct.api.ads.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error.java;

/**
 * Created by pavryabov on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Неправильный запрос")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class InvalidRequestTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void emptyRequest() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap(),
                java(new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(AddRequestMap.ADS)))

                        .perl(new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                "params", capitalize(AddRequestMap.ADS)))
        );
    }

    @Test
    public void emptyArrayOfAds() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap().withAds(),
                java(new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(AddRequestMap.ADS), 1))

                        .perl(new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                                capitalize(AddRequestMap.ADS))));
    }

    @Test
    public void requestWithoutAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(new AdAddItemMap().withAdGroupId(adGroupId)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(
                                5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                //перечень названий типов должен соответствовать типам в
                                // ru.yandex.direct.api.v5.entity.ads.validation.AdTypeNames
                                "TextAd, DynamicTextAd, MobileAppAd, TextImageAd, MobileAppImageAd, TextAdBuilderAd, " +
                                        "MobileAppAdBuilderAd, CpmBannerAdBuilderAd, CpcVideoAdBuilderAd, " +
                                        "CpmVideoAdBuilderAd, ContentPromotionVideoAd, ContentPromotionCollectionAd, " +
                                        "ContentPromotionServiceAd, ContentPromotionEdaAd, SmartAdBuilderAd, " +
                                        "MobileAppCpcVideoAdBuilderAd")))
                        .perl(ExpectedResult.errors(new Notification(
                                5008, Api5ErrorDetails.AD_MUST_CONTAIN_ONLY_ONE_OF_THE_OBJECTS))));
    }

}
