package ru.yandex.autotests.direct.api.ads.add;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Неправильные типы в простых полях")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class InvalidTypesOfFieldsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void arrayInText() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), new String[]{TextAdAddMap.DEFAULT_TEXT});
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.TEXT))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInText() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), "null");
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.TEXT))
        );
    }

    @Test
    public void arrayInTitle() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), new String[]{TextAdAddMap.DEFAULT_TITLE});
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.TITLE))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInTitle() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), "null");
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.TITLE))
        );
    }

    @Test
    public void arrayInTitle2() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.TITLE_2), new String[]{TextAdAddMap.DEFAULT_TITLE_2});
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.TITLE_2))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInTitle2() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.TITLE_2), "null");
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.TITLE_2))
        );
    }

    @Test
    public void arrayInHref() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), new String[]{TextAdAddMap.DEFAULT_HREF});
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.HREF))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInHref() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), "null");
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.HREF))
        );
    }

    @Test
    public void arrayInMobile() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), new Object[]{YesNoEnum.NO.toString()});
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.MOBILE))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInMobile() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), "null");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE, capitalize(TextAdAddMap.MOBILE)));
    }

    @Test
    public void arrayInVCardId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.VCARD_ID), new Long[]{123l});
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.VCARD_ID))
                                        .collect(joining("."))));
    }

    @Test
    public void stringInVCardId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.VCARD_ID), "value");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.VCARD_ID))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInVCardId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.VCARD_ID), "null");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.VCARD_ID))
        );
    }

    @Test
    public void arrayInAdImageHash() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.ADIMAGE_HASH), new String[]{"hash"});
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.ADIMAGE_HASH))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInAdImageHash() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.ADIMAGE_HASH), "null");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(TextAdAddMap.ADIMAGE_HASH))
        );
    }

    @Test
    public void arrayInSitelinkSetId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.SITELINK_SET_ID), new Long[]{123l});
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.SITELINK_SET_ID))
                                        .collect(joining("."))));
    }

    @Test
    public void stringInSitelinkSetId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.SITELINK_SET_ID), "value");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.SITELINK_SET_ID))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInSitelinkSetId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        textAd.put(capitalize(TextAdAddMap.SITELINK_SET_ID), "null");
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.TEXT_AD), capitalize(TextAdAddMap.SITELINK_SET_ID))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayInAdGroupId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), new Long[]{adGroupId});
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of("Ads", capitalize(AdAddItemMap.ADGROUP_ID))
                                        .collect(joining("."))));
    }

    @Test
    public void stringInAdGroupId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), "value");
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of("Ads", capitalize(AdAddItemMap.ADGROUP_ID))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInAdGroupId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), YesNoEnum.NO);
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), "null");
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdAddItemMap.ADGROUP_ID))
        );
    }
}
