package ru.yandex.autotests.direct.api.ads.add;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;

/**
 * Created by pavryabov on 26.06.15.
 * https://st.yandex-team.ru/TESTIRT-6079
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Неправильные значения в полях, принимающих Enum'ы")
@Issue("https://st.yandex-team.ru/DIRECT-42167")
public class InvalidValuesInEnumsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void invalidValueInMobile() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        JSONObject textAd = new JSONObject();
        textAd.put(capitalize(TextAdAddMap.TEXT), TextAdAddMap.DEFAULT_TEXT);
        textAd.put(capitalize(TextAdAddMap.TITLE), TextAdAddMap.DEFAULT_TITLE);
        textAd.put(capitalize(TextAdAddMap.HREF), TextAdAddMap.DEFAULT_HREF);
        textAd.put(capitalize(TextAdAddMap.MOBILE), uncapitalize(YesNoEnum.NO.toString()));
        ad.put(capitalize(AdAddItemMap.TEXT_AD), textAd);
        ad.put(capitalize(AdAddItemMap.ADGROUP_ID), adGroupId);
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(AddRequestMap.ADS),
                                capitalize(AdAddItemMap.TEXT_AD),
                                capitalize(AdsSelectionCriteriaMap.MOBILE))
                                .collect(joining(".")),
                        "YES, NO"));
    }
}
