package ru.yandex.autotests.direct.api.ads.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Полный запрос в SOAP")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
public class RequestInSOAPTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT_SHARD2);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long vCardId;
    private static Long sitelinkSetId;
    private static String adImageHash;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT_SHARD2);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT_SHARD2);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        adImageHash = api.userSteps.imagesSteps().configLoginImages(AdsLogins.CLIENT_SHARD2, ImageType.REGULAR, 1)[0];
    }

    @Test
    public void checkSOAP() {
        //DIRECT-41119
        api.protocol(ProtocolType.SOAP).userSteps.adsSteps()
                .shouldGetResultOnAdd(new AddRequestMap()
                                .withAds(new AdAddItemMap()
                                        .withTextAd(new TextAdAddMap()
                                                .defaultTextAd()
                                                .withVCardId(vCardId)
                                                .withAdImageHash(adImageHash)
                                                .withSitelinkSetId(sitelinkSetId))
                                        .withAdGroupId(adGroupId)),
                        ExpectedResult.success());
    }
}
