package ru.yandex.autotests.direct.api.ads.add;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdFeatureItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка обязательности указания полей")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class RequiredFieldsTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long vCardId;

    private static Long mobileAppAdGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        api.userSteps.sitelinksSteps().addDefaultSet(1);

        api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(mobileAppAdGroupId, PhrasesAdgroupType.mobile_content);
    }

    @Test
    public void requestWithoutText() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withHref(TextAdAddMap.DEFAULT_HREF)
                                        .withMobile(YesNoEnum.NO))
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(TextAdAddMap.TEXT)));
    }

    @Test
    public void requestWithoutTitle() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withHref(TextAdAddMap.DEFAULT_HREF)
                                        .withMobile(YesNoEnum.NO))
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(TextAdAddMap.TITLE)));
    }

    @Test
    public void requestWithoutMobile() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withHref(TextAdAddMap.DEFAULT_HREF))
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(TextAdAddMap.MOBILE)));
    }

    @Test
    public void requestWithoutHrefAndVCardId() {
        //DIRECT-41037
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withMobile(YesNoEnum.NO))
                                .withAdGroupId(adGroupId)),
                JavaOrPerlExpectedResult.expect(6000,
                        Api5ErrorDetails.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF,
                        Api5ErrorDetailsJava.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF));
    }

    @Test
    public void requestWithoutHrefWithVCardId() {
        //DIRECT-41037
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withMobile(YesNoEnum.NO)
                                        .withVCardId(vCardId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
    }

    @Test
    public void requestWithEmptyHrefWithVCardId() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withHref("")
                                        .withMobile(YesNoEnum.NO)
                                        .withVCardId(vCardId))
                                .withAdGroupId(adGroupId)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(5003, Api5ErrorDetailsJava.EMPTY_HREF)))
                        .perl(ExpectedResult.errors(
                                new Notification(5003, Api5ErrorDetails.SET_EMPTY_VALUE_IN_FIELD,
                                        capitalize(TextAdAddMap.HREF)))));
    }

    @Test
    public void requestWithoutAdGroupId() {
        JSONObject request = new JSONObject();
        JSONObject ad = new JSONObject();
        ad.put(capitalize(AdAddItemMap.TEXT_AD), new TextAdAddMap()
                .withText(TextAdAddMap.DEFAULT_TEXT)
                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                .withHref(TextAdAddMap.DEFAULT_HREF)
                .withMobile(YesNoEnum.NO).getBean());
        request.put(capitalize(AddRequestMap.ADS), new Object[]{ad});
        api.userSteps.adsSteps().expectErrorOnAdsAdd(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.ADS), capitalize(AdAddItemMap.ADGROUP_ID)));
    }

    @Test
    @Description("Запрос на создание объявления с рекламой мобильного приложения без заголовка")
    public void requestWithoutTitleField() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(
                                new AdAddItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withMobileAppAd(new MobileAppAdAddMap()
                                                .defaultMobileAppAd()
                                                .withText(MobileAppAdAddMap.DEFAULT_TEXT)
                                                .withTitle(null))),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(TextAdAddMap.TITLE)));
    }

    @Test
    @Description("Запрос на создание объявления с рекламой мобильного приложения без ссылки на систему статистики")
    public void requestWithoutTrackingUrlField() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withTrackingUrl(null))),
                ExpectedResult.success());
    }

    @Test
    @Description("Запрос на создание объявления с рекламой мобильного приложения без Features")
    public void requestWithoutFeaturesField() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withFeatures((MobileAppAdFeatureItemMap[]) null))),
                ExpectedResult.success());
    }

    @Test
    @Description("Запрос на создание объявления с рекламой мобильного приложения без" +
            " ссылки на систему статистики и без Features")
    public void requestWithoutTrackingUrlAndFeaturesFields() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(
                new AdAddItemMap()
                        .withAdGroupId(mobileAppAdGroupId)
                        .withMobileAppAd(new MobileAppAdAddMap()
                                .defaultMobileAppAd()
                                .withTrackingUrl(null)
                                .withFeatures((MobileAppAdFeatureItemMap[]) null))),
                ExpectedResult.success());
    }

    @Test
    public void requestWithoutTextInDynamicTextAd() {
        api.userSteps.adsSteps().expectErrorOnAdsAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(new DynamicTextAdAddMap())
                                .withAdGroupId(adGroupId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(TextAdAddMap.TEXT)));
    }
}
