package ru.yandex.autotests.direct.api.ads.add;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by pavryabov on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5093
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Попытка установить SitelinkSetId без указания основной ссылки")
@Issue("https://st.yandex-team.ru/DIRECT-34558")
@Tag(TagDictionary.TRUNK)
public class SetSitelinkSetWithoutHrefTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    private static Long vCardId;
    private static Long sitelinkSetId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
    }

    @Test
    public void requestWithoutHrefWithSitelinkSetId() {
        //DIRECT-41070
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withMobile(YesNoEnum.NO)
                                        .withVCardId(vCardId)
                                        .withSitelinkSetId(sitelinkSetId))
                                .withAdGroupId(adGroupId)),
                expect(6000,
                        Api5ErrorDetails.SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED,
                        Api5ErrorDetailsJava.SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED));
    }

    @Test
    public void requestWithoutHrefAndVCardsIdWithSitelinkSetId() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(new TextAdAddMap()
                                        .withText(TextAdAddMap.DEFAULT_TEXT)
                                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                        .withMobile(YesNoEnum.NO)
                                        .withSitelinkSetId(sitelinkSetId))
                                .withAdGroupId(adGroupId)),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(
                                new Notification(6000, Api5ErrorDetailsJava.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF),
                                new Notification(6000, Api5ErrorDetailsJava.SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED)))
                        .perl(ExpectedResult.errors(
                                new Notification(6000, Api5ErrorDetails.AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF),
                                new Notification(6000, Api5ErrorDetails.SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED))));
    }
}
