package ru.yandex.autotests.direct.api.ads.add;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка статуса StatusBsSynced после добавления объявления")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@RunWith(Parameterized.class)
public class StatusBsSyncAfterAddAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;
    private Long adId1;
    private Long adId2;
    private GroupFakeInfo groupFakeInfo;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId1 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId1, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        adId2 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
    }

    @Test
    public void firstAdStatusBsSyncedAfterAddSecondAd() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    public void secondAdStatusBsSyncedAfterAdd() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-55529")
    //после починки бага добавить графические объявления
    public void adGroupStatusBsSyncedAfterAdd() {
        groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }
}
