package ru.yandex.autotests.direct.api.ads.add.cpcvideoadbuilderad;

import java.util.Collection;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Href. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-82653")
@RunWith(Parameterized.class)
public class AddCpcVideoAdBuilderAdHrefValidationPositiveTest {
    static String CLIENT = AdsLogins.CLIENT40;
    private static Long adGroupId;
    private static DirectJooqDbSteps dbSteps;
    private static Long creativeId;
    private CpcVideoAdBuilderAdAddMap cpcVideoAdBuilderAdAddMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String href;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return AdsHrefValidationHelper.getHrefDataForPositiveParameterized();
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Before
    public void initMap() {
        cpcVideoAdBuilderAdAddMap = new CpcVideoAdBuilderAdAddMap()
                .withCreative(creativeId)
                .withHref(href);
    }

    @Test
    public void addWithHrefAndCheckSave() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withCpcVideoAdBuilderAd(cpcVideoAdBuilderAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        assertThat("ссылка баннера сохранилась верно", dbSteps.bannersSteps().getBanner(id).getHref(), equalTo(href));
    }

}
