package ru.yandex.autotests.direct.api.ads.add.cpcvideoadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка создания в БД кликового видеообъявления")
@Issue("https://st.yandex-team.ru/DIRECT-82653")
@RunWith(Parameterized.class)
public class AddCpcVideoAdBuilderAdRolesTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public String loginToCreateAd;

    @Parameterized.Parameter(4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(5)
    public Api5Error expectedJavaError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Создание объявления от имени менеджера", Logins.MANAGER_DEFAULT, AdsLogins.SERV_CLIENT,
                        AdsLogins.MANAGER_DEFAULT,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени вешальщика", Logins.PLACER, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},

                {"Создание объявления от имени саппорта", Logins.SUPPORT, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени супера", Logins.SUPER_LOGIN, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени медиапланера", Logins.MEDIA, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},

                {"Создание объявления от имени суперридера", Logins.SUPER_READER, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},

                {"Создание объявления от имени клиента для самого себя", AdsLogins.CLIENT, AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени представителя клиента для клиента", AdsLogins.CLIENT_REP,
                        AdsLogins.CLIENT,
                        AdsLogins.CLIENT,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени агенства для субклиента", AdsLogins.AGENCY, AdsLogins.SUBCLIENT,
                        AdsLogins.AGENCY,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени представителя агенства для субклиента", AdsLogins.AGENCY_REP,
                        AdsLogins.SUBCLIENT,
                        AdsLogins.AGENCY_REP,
                        ExpectedResult.success(), null},

                {"Создание объявления от имени субклиента", AdsLogins.SUBCLIENT, AdsLogins.SUBCLIENT,
                        AdsLogins.AGENCY,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)}
        });
    }

    private Long adGroupId;
    private Long creativeId;

    @Before
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(loginToCreateAd);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(login).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(login).getClientID()));
    }

    @Test
    public void requestUsingLogin() {
        try {
            api.as(apiUserLogin);
            api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                    .withAdGroupId(adGroupId)
                    .withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdAddMap()
                            .defaultCpcVideoAdBuilderAd(creativeId))), login, expectedResult);

        } catch (Api5JsonError jsonError) {
            // Java версия сервиса возвращает 54-ю ошибку на весь запрос
            if (expectedJavaError == null) {
                throw new AssertionError("неожиданная ошибка", jsonError);
            }
            assertThat("совпал текст ошибки (JSON)", jsonError,
                    Api5JsonErrorMatcher.equalToIgnoreLocale(expectedJavaError.toJsonError()));
        }
    }
}
