package ru.yandex.autotests.direct.api.ads.add.cpcvideoadbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Попытка добавления кликового видеообъявления в нетекстовую группу")
@Issue("https://st.yandex-team.ru/DIRECT-82653")
public class AddCpcVideoAdToIncompatibleAdGroupNegativeTest {
    private static String client = AdsLogins.CLIENT25;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.as(client).userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(client).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(client).getClientID()));
    }

    @Test
    public void addImageAdToDynamicTextAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withCpcVideoAdBuilderAd(
                                new CpcVideoAdBuilderAdAddMap().defaultCpcVideoAdBuilderAd(creativeId)
                        ).withAdGroupId(adGroupId)
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP)
                )
        );
    }

}
