package ru.yandex.autotests.direct.api.ads.add.cpmbanneradbuilderad;

import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;

import static java.util.Collections.singletonList;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации пикселя аудита TNS")
public class AddCpmAdTnsPixelTest {

    private static final String clientLogin = AdsLogins.SUBCLIENT;
    private static final String agencyLogin = AdsLogins.AGENCY;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(agencyLogin);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long creativeId;
    private static String tnsPixelUrl =
            "https://www.tns-counter.ru/V13a****bbdo_ad/ru/UTF-8/tmsec=bbdo_cid1021927-posid1323236/%aw_random%";

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agencyLogin);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(clientLogin);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId, clientLogin);

        creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(clientLogin).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(clientLogin).getClientID()));
        deleteFromClientPixelProviders();
    }

    private static void deleteFromClientPixelProviders() {
        api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(clientLogin)
                .clientPixelProvidersSteps()
                .deleteClientProviders(Long.parseLong(User.get(clientLogin).getClientID()));
    }

    @Test
    @Description("Попытка добавить баннер с тнс-пикселем")
    public void testBannerWithTnsPixelAdd() {
        AdAddItemMap adAddItemMap = cpmAdAddItemMapByAdGroupAndPixel(adGroupId, singletonList(tnsPixelUrl));
        api.userSteps.adsSteps()
                .shouldGetResultOnAdd(new AddRequestMap().withAds(adAddItemMap),
                        clientLogin,
                        ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.NO_RIGHTS_TO_PIXEL,
                                tnsPixelUrl))
                );
    }

    private AdAddItemMap cpmAdAddItemMapByAdGroupAndPixel(Long adGroupId, List<String> trackingPixels) {
        return new AdAddItemMap()
                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdAddMap()
                        .withHref(CpmBannerAdBuilderAdAddMap.DEFAULT_HREF)
                        .withCreative(creativeId)
                        .withTrackingPixels(trackingPixels))
                .withAdGroupId(adGroupId);
    }
}
