package ru.yandex.autotests.direct.api.ads.add.cpmbanneradbuilderad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.PixelProvider;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class AddCpmBannerTypesTest {

    private static String LOGIN = AdsLogins.CLIENT47;
    private static String HREF = "https://ya.ru";
    private static String PIXEL = PixelProvider.YANDEXAUDIENCE.testUrl();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long id;
    private static DirectJooqDbSteps dbSteps =
            api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);
    private static Long creativeId;
    private static Long videoCreativeId;

    @BeforeClass
    public static void initTest() {
        api.as(LOGIN).userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));

        videoCreativeId = dbSteps.perfCreativesSteps().saveDefaultVideoCreative(
                Long.parseLong(User.get(LOGIN).getClientID()), 6L);
    }

    @Test
    public void addToCpmDealsCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_DEALS);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdAddMap().defaultCpmBannerAdBuilderAd(creativeId))),
                ExpectedResult.success());
    }

    @Test
    public void tryAddToCpmVideoAdGroup() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmVideoGroup(campaignId);
        dbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.cpm_video);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withCpmVideoAdBuilderAd(
                                        new CpmVideoAdBuilderAdAddMap().defaultCpmVideoAdBuilderAd(videoCreativeId))),
                ExpectedResult.success());
    }
}
