package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 09.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка доступа к AdExtensionIds для динамических текстовых объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
@Tag(TagDictionary.TRUNK)
public class AccessToAdExtensionIdsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static DynamicTextAdAddMap dynamicTextAdAddMap;
    Long adExtensionId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextAdAddMap = new DynamicTextAdAddMap().defaultDynamicTextAd();
    }

    @Before
    public void createAdExtension() {
        api.as(AdsLogins.CLIENT);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void addWithMyAdExtensionId() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(adExtensionId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.AD_EXTENSIONS));
        assertThat("AdExtensionId сохранился верно", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void addWithNotMyAdExtensionId() {
        //DIRECT-51922
        api.as(AdsLogins.CLIENT_ELSE);
        Long notMyAdExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        api.as(AdsLogins.CLIENT);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(notMyAdExtensionId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, notMyAdExtensionId)));
    }

    @Test
    public void addWithNonExistentAdExtensionId() {
        Long nonExistentAdExtensionId = adExtensionId + 100000;
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(nonExistentAdExtensionId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, nonExistentAdExtensionId)));
    }

    @Test
    public void addWithZeroAdExtensionId() {
        //DIRECT-51921
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(0l))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_BE_POSITIVE_INTEGER,
                        capitalize(DynamicTextAdAddMap.AD_EXTENSION_IDS), 1)));
    }

    @Test
    public void addWithNegativeAdExtensionId() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(-1l))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(5005, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_BE_POSITIVE_INTEGER,
                        capitalize(DynamicTextAdAddMap.AD_EXTENSION_IDS), 1)));
    }
}
