package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 27.11.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка доступа к VCardId для динамических текстовых объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class AccessToVCardIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static DynamicTextAdAddMap dynamicTextAdAddMap;
    private Long vCardId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextAdAddMap = new DynamicTextAdAddMap().defaultDynamicTextAd();
    }

    @Before
    public void createVcard() {
        api.as(AdsLogins.CLIENT);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
    }

    @Test
    public void addWithMyVCardId() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withVCardId(vCardId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.V_CARD_ID));
        assertThat("VCardId сохранился верно", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id)
                        .withDynamicTextAd(new DynamicTextAdGetMap().withVCardId(vCardId)).getBean())));
    }

    @Test
    public void addWithNotMyVCardId() {
        //DIRECT-41079
        api.as(AdsLogins.CLIENT_ELSE);
        Long notMyCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT_ELSE);
        Long notMyVCardId = api.userSteps.vCardsSteps().addDefaultVCard(notMyCampaignId);
        api.as(AdsLogins.CLIENT);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withVCardId(notMyVCardId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.VCARD_NOT_FOUND)));
    }

    @Test
    public void addWithNonExistentVCardId() {
        //DIRECT-41079
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withVCardId(vCardId + 100000))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.VCARD_NOT_FOUND)));
    }

    @Test
    public void addWithDeletedVCardId() {
        //DIRECT-41079
        api.userSteps.vCardsSteps().vCardsDelete(vCardId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withVCardId(vCardId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.VCARD_NOT_FOUND)));
    }

    @Test
    public void addWithVCardIdFromOtherMyCampaign() {
        Long otherCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long otherVCardId = api.userSteps.vCardsSteps().addDefaultVCard(otherCampaignId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withVCardId(otherVCardId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.VCARD_NOT_BELONGS_TO_CAMPAIGN)));
    }
}
