package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;

/**
 * Created by pavryabov on 11.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка лимита на количество уточнений")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
public class AdExtensionIdsLimitTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static DynamicTextAdAddMap dynamicTextAdAddMap;
    static Long adExtensionId;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextAdAddMap = new DynamicTextAdAddMap().defaultDynamicTextAd();
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void addWithMaxAmountAdExtensionId() {
        Long[] adExtensionIds = new Long[DynamicTextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD];
        Arrays.fill(adExtensionIds, adExtensionId);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(adExtensionIds))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(
                        new Notification(9802,
                                Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_AD_EXTENSIONS_MORE_THAN_ONCE, adExtensionId)));
    }

    @Test
    public void addWithMoreThanMaxAmountAdExtensionIdInRequest() {
        Long[] adExtensionIds = new Long[DynamicTextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD + 1];
        Arrays.fill(adExtensionIds, adExtensionId);
        ExpectedResult[] expectedResults = new ExpectedResult[AddRequestMap.MAX_AMOUNT_OF_ADS_IN_GROUP];
        Arrays.fill(expectedResults, ExpectedResult.success());
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(adExtensionIds))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(
                        new Notification(7000,
                                Api5ErrorDetailsJava.ADEXTENSIONS_ARRAY_CANNOT_CONTAIN_MORE_THAN,
                                capitalize(DynamicTextAdAddMap.AD_EXTENSION_IDS),
                                DynamicTextAdAddMap.MAX_AD_EXTENSION_IDS_IN_AD)));
    }
}
