package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.CompareStrategy;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Banners.BANNERS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath.newPath;

/**
 * Created by pavryabov on 30.11.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка сохранения в базе динамических текстовых баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@Tag(TagDictionary.TRUNK)
public class AddDynamicTextAdCheckDatabaseTest {


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String DYNAMIC_TITLE = "{Dynamic title}";

    static Long campaignId;
    static Long adGroupId;
    static Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        AddResponse addResponse = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        id = addResponse.getAddResults().get(0).getId();
    }

    @Test
    public void addOneAdAndCheckDBValues() {
        BannersRecord actual = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AdsLogins.CLIENT)
                .bannersSteps()
                .getBanner(id);
        BannersRecord expected = new BannersRecord()
                .with(BANNERS.BID, id)
                .with(BANNERS.BANNER_TYPE, BannersBannerType.dynamic)
                .with(BANNERS.BODY, DynamicTextAdAddMap.DEFAULT_TEXT)
                .with(BANNERS.TITLE, DYNAMIC_TITLE)
                .with(BANNERS.CID, campaignId)
                .with(BANNERS.PID, adGroupId)
                .with(BANNERS.TYPE, BannersType.desktop);
        CompareStrategy strategy = DefaultCompareStrategies.onlyExpectedFields()
                .forFields(newPath("table")).useMatcher(notNullValue());
        assertThat("объявление правильно сохранилось в базе",
                actual, beanDiffer(expected).useCompareStrategy(strategy));
    }

    @Test
    public void addOneAdAndCheckHrefInDB() {
        BannersRecord bannersRecord = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(AdsLogins.CLIENT)
                .bannersSteps()
                .getBanner(id);
        assertThat("Href = null", bannersRecord.getHref(), nullValue());
    }
}
