package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonErrorMatcher;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 30.11.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка добавления динамических текстовых объявлений от имени разных ролей")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddDynamicTextAdRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String apiUserLogin;

    @Parameter(2)
    public String login;

    @Parameter(3)
    public String loginToCreateGroup;

    @Parameter(4)
    public ExpectedResult expectedResult;

    @Parameter(5)
    public Api5Error expectedError;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{

                {"Добавление объявления от имени агенства для субклиента",
                        AdsLogins.AGENCY, AdsLogins.SUBCLIENT, AdsLogins.AGENCY,
                        ExpectedResult.success(), null},

                {"Добавление объявления от имени представителя агенства для субклиента",
                        AdsLogins.AGENCY_REP, AdsLogins.SUBCLIENT, AdsLogins.AGENCY_REP,
                        ExpectedResult.success(), null},

                {"Добавление объявления от имени субклиента",
                        AdsLogins.SUBCLIENT, AdsLogins.SUBCLIENT, AdsLogins.AGENCY,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)}
        });
    }

    private long adGroupID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);
        api.as(loginToCreateGroup);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign(login);
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId, login);
    }

    @Test
    public void requestUsingLogin() {
        try {
            api.as(apiUserLogin);
            api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap().withAds(new AdAddItemMap()
                    .withAdGroupId(adGroupID)
                    .withDynamicTextAd(new DynamicTextAdAddMap()
                            .defaultDynamicTextAd())), login, expectedResult);
        } catch (Api5JsonError jsonError) {
            // Java версия сервиса возвращает 54-ю ошибку на весь запрос
            if (expectedError == null) {
                throw new AssertionError("неожиданная ошибка", jsonError);
            }
            assertThat("совпал текст ошибки (JSON)", jsonError,
                    Api5JsonErrorMatcher.equalToIgnoreLocale(expectedError.toJsonError()));
        }
    }
}
