package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 11.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка привязки нескольких уточнений к динамическим текстовым объявлениям")
@Issue("https://st.yandex-team.ru/DIRECT-50726")
public class AddDynamicTextAdWithSeveralCalloutsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static DynamicTextAdAddMap dynamicTextAdAddMap;
    private static Long calloutId;
    private static Long calloutIdElse;


    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextAdAddMap = new DynamicTextAdAddMap().defaultDynamicTextAd();
        calloutId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        calloutIdElse = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
    }

    @Test
    public void addWithTwoValidCallouts() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(calloutId, calloutIdElse))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.AD_EXTENSIONS));
        assertThat("AdExtensionId сохранился верно", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(id)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                                .withAdExtensionId(calloutId)
                                                .withType(AdExtensionTypeEnum.CALLOUT),
                                        new AdExtensionAdGetItemMap()
                                                .withAdExtensionId(calloutIdElse)
                                                .withType(AdExtensionTypeEnum.CALLOUT))).getBean())));
    }

    @Test
    public void addWithValidAndInvalidCallouts() {
        Long invalidCalloutId = calloutId + 10000;
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(calloutId, invalidCalloutId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, invalidCalloutId)));
    }

    @Test
    public void addWithTwoInvalidCallouts() {
        Long invalidCalloutId = calloutId + 10000;
        Long invalidCalloutIdElse = calloutId + 10100;
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(invalidCalloutId, invalidCalloutIdElse))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, invalidCalloutId),
                        new Notification(8800, Api5ErrorDetails.AD_EXTENSION_NOT_FOUND, invalidCalloutIdElse)
                ));
    }

    @Test
    public void addWithTwoSameCallouts() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap.withAdExtensionIds(calloutId, calloutId))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(
                        new Notification(9802,
                                Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_AD_EXTENSIONS_MORE_THAN_ONCE, calloutId)
                ));
    }

    @Test
    public void addWithTwoPairsOfSameCallouts() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withDynamicTextAd(dynamicTextAdAddMap
                                        .withAdExtensionIds(calloutId, calloutIdElse, calloutId, calloutIdElse))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(
                        new Notification(9802,
                                Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_AD_EXTENSIONS_MORE_THAN_ONCE, calloutId),
                        new Notification(9802,
                                Api5ErrorDetails.VALUE_CANNOT_BE_PRESENT_IN_AD_EXTENSIONS_MORE_THAN_ONCE, calloutIdElse)
                ));
    }
}
