package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 11.08.16.
 * https://st.yandex-team.ru/TESTIRT-10037
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Создание динамических текстовых объявлений в ДО-группе с фидом")
@Issue("https://st.yandex-team.ru/DIRECT-55149")
public class AddDynamicTextFeedAdsTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId1;
    private static Long adGroupId2;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId1, feedId);
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId2, feedId);
    }

    @Test
    public void addOneAd() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                        .withAdGroupId(adGroupId1)), ExpectedResult.success());
    }

    @Test
    public void addTwoAdsInOneGroup() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                .withAdGroupId(adGroupId1),
                        new AdAddItemMap()
                                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                .withAdGroupId(adGroupId1)), ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void addTwoAdsInTwoGroups() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                .withAdGroupId(adGroupId1),
                        new AdAddItemMap()
                                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd())
                                .withAdGroupId(adGroupId2)), ExpectedResult.success(), ExpectedResult.success());
    }
}
