package ru.yandex.autotests.direct.api.ads.add.dynamictextad;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 02.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка независимости статуса модерации динамического текстового объявления от статусов других объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class DynamicTextAdCheckStatusModerateAfterAddTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void getUserShard() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    private Long campaignId;
    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
    }

    @Test
    @Description("Добавить объявление в пустую кампанию")
    public void addAdToEmptyCampaign() {
        long adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @Description("Добавить объявление в кампанию, у которой есть объявление, отправленное на модерацию")
    public void addAdToCampaignWithSentBanner() {
        long moderatedId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        api.userSteps.adsSteps().adsModerate(moderatedId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(moderatedId);
        assumeThat("объявление отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));

        long adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @Description("Добавить объявление в активную кампанию")
    public void addAdToActiveCampaign() {
        long activeAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerActive(activeAdId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(activeAdId);
        assumeThat("объявление активно", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));

        long adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }
}
