package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AddResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.enums.AdActionObjectType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка возможности установить различные значения Action для объявления РМП")
@RunWith(Parameterized.class)
public class AddMobileAppAdActionTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public AdActionObjectType appAdAction;

    private static int shard;

    @Parameterized.Parameters(name = "Action = {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(AdActionObjectType.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static long adGroupId;

    @BeforeClass
    public static void createAdGroup() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        api.userSteps
                .getDirectJooqDbSteps()
                .useShard(shard)
                .adGroupsSteps()
                .updatePhrases(new PhrasesRecord()
                        .setPid(adGroupId)
                        .setAdgroupType(PhrasesAdgroupType.mobile_content));
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    /**
     *  Обновлено для
     *  https://st.yandex-team.ru/TESTIRT-10149
     */
    @Test
    public void addAdWithAction() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAction(appAdAction.getMobileAppAdAction()))
                        ),
                ExpectedResult.success());
        Long adId = response.getAddResults().get(0).getId();

        BannersMobileContentRecord actualMobileContent = api.userSteps
                .getDirectJooqDbSteps()
                .useShard(shard)
                .mobileContentSteps()
                .getBannersMobileContent(adId);

        Assert.assertThat("действие создано верно",
                actualMobileContent.getPrimaryAction().toString(),
                equalTo(appAdAction.getPrimaryAction().toString()));
    }
}
