package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.lowerCase;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

/**
 * Created by semkagtn on 18.09.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка возможности установить различные значения AgeLabel, используя метод add")
@Issue("https://st.yandex-team.ru/DIRECT-46329")
@RunWith(Parameterized.class)
public class AddMobileAppAdAgeLabelSaveToDatabaseTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public MobAppAgeLabelEnum ageLabel;

    @Parameterized.Parameter(1)
    public String expectedFlags;

    @Parameterized.Parameters(name = "AgeLabel = {0}")
    public static Iterable<Object[]> data() {
        List<Object[]> parameters = Stream.of(MobAppAgeLabelEnum.values())
                .map(ageLabel -> new Object[]{ageLabel, lowerCase(ageLabel.toString()).replace('_', ':')})
                .collect(Collectors.toList());
        parameters.add(new Object[]{null, "age:18"}); // default value checking
        return parameters;
    }

    private static long adGroupId;

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId, LOGIN);
    }

    @Test
    public void addMobileAppAdWithAgeLabel() {
        long adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withAgeLabel(ageLabel)));

        String actualFlags = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN)
                .bannersSteps()
                .getBanner(adId)
                .getFlags();

        assertThat( "флаги объявления соответствуют ожиданию", actualFlags, is(expectedFlags));
    }
}
