package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.MobileAppAdFeatureGetItem;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import com.yandex.direct.api.v5.general.YesNoUnknownEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.AdgroupsMobileContentUtils;
import ru.yandex.autotests.directapi.darkside.model.MobileContentUtils;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdFeatureGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Comparator.comparing;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 29.09.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка значения по умолчанию для поля Features в методе add")
public class AddMobileAppAdDefaultFeaturesTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adGroupId;

    @BeforeClass
    public static void createAdGroup() {
        String clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);
        long mobileContentId =
                jooqDbSteps.mobileContentSteps().saveMobileContent(MobileContentUtils.getDefaultMobileContent(clientId));
        AdgroupsMobileContentRecord adgroupsMobileContentRecord =
                AdgroupsMobileContentUtils.getDefaultAdgroupsMobileContent(adGroupId, mobileContentId);
        jooqDbSteps.mobileContentSteps().saveAdgroupsMobileContent(adgroupsMobileContentRecord);

    }

    private long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .withAction(MobileAppAdAddMap.DEFAULT_ACTION)
                        .withTitle(MobileAppAdAddMap.DEFAULT_TITLE)
                        .withText(MobileAppAdAddMap.DEFAULT_TEXT)
                        .withTrackingUrl(MobileAppAdAddMap.DEFAULT_TRACKING_URL)));
    }

    @Test
    public void addAdWithFeatures() {
        List<AdGetItem> ads = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))).getAds();
        assumeThat("вернулось одно объявление", ads, hasSize(1));

        List<MobileAppAdFeatureGetItem> features = new ArrayList<>(ads.get(0).getMobileAppAd().getFeatures());
        // Сортируем, чтобы не зависеть от порядка. Java список в ответе сортирует по имени, Perl – нет.
        features.sort(comparing(f -> f.getFeature().name()));
        assertThat("вернулось верное значение по-умолчанию для массива Features",
                features, beanDiffer(Arrays.asList(
                        new MobileAppAdFeatureGetItemMap()
                                .withIsAvailable(YesNoUnknownEnum.YES)
                                .withEnabled(YesNoEnum.NO)
                                .withFeature(MobileAppFeatureEnum.CUSTOMER_RATING).getBean(),
                        new MobileAppAdFeatureGetItemMap()
                                .withIsAvailable(YesNoUnknownEnum.YES)
                                .withEnabled(YesNoEnum.NO)
                                .withFeature(MobileAppFeatureEnum.ICON).getBean(),
                        new MobileAppAdFeatureGetItemMap()
                                .withIsAvailable(YesNoUnknownEnum.YES)
                                .withEnabled(YesNoEnum.NO)
                                .withFeature(MobileAppFeatureEnum.PRICE).getBean(),
                        new MobileAppAdFeatureGetItemMap()
                                .withIsAvailable(YesNoUnknownEnum.YES)
                                .withEnabled(YesNoEnum.NO)
                                .withFeature(MobileAppFeatureEnum.RATINGS).getBean())));
    }
}
