package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.success;
import static ru.yandex.autotests.directapi.model.api5.general.ExpectedResult.warnings;

@Aqua.Test
@Features(AdsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-82971")
@Description("Проверка валидации трекинговой ссылки")
@RunWith(Parameterized.class)
public class AddMobileAppAdTrackingUrlNewRmpValidationTest {
    private static final String CLIENT_WITH_FEATURE_FLAG = Logins.CLIENT_NEW_RMP;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public String trackingUrl;

    @Parameterized.Parameter(3)
    public ExpectedResult result;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"With {logid} for client with feature flag",
                        CLIENT_WITH_FEATURE_FLAG,
                        "https://app.appsflyer.com/112132123?pid=yandexdirect_int&clickid={logid}",
                        success()},
                {"Without {logid} for client with feature flag",
                        CLIENT_WITH_FEATURE_FLAG,
                        "https://app.appsflyer.com/112132123?pid=yandexdirect_int",
                        warnings(new Notification(10250))},
                {"Without {logid} but for adjust for client with feature flag",
                        CLIENT_WITH_FEATURE_FLAG,
                        "https://app.adjust.com/234234234234",
                        success()},
        });
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        Long campaignId = api.as(login).userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.as(login).userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    public void addWithTrackingUrlAndCheckResult() {
        api.as(login).userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                        new AdAddItemMap().withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withTrackingUrl(trackingUrl)
                        ).withAdGroupId(adGroupId)
                ),
                result
        );
    }
}
