package ru.yandex.autotests.direct.api.ads.add.mobileappad;


import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.db.utils.JooqRecordDifferMatcher.recordDiffer;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 01.03.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Description("Проверка добавления изображения к РМП")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Feature(AdsFeatures.ADD)
public class AddMobileAppAdWithAdImageTest {

    private static final String LOGIN = AdsLogins.CLIENT22;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;
    private Long adGroupId;
    private Long campaignId;

    private int userShard;

    private String wideAssociatedHash;
    private String regularAssociatedHash;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        userShard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        String[] wideHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.WIDE, false,1);
        wideAssociatedHash = wideHashes[0];

        String[] regularHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, false,  1);
        regularAssociatedHash = regularHashes[0];

        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    public void addMobileAppAdWithWideAdImage() {
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAdImageHash(wideAssociatedHash)
                        )
        );

        BannerImagesRecord actualBannerImage =
                api.userSteps.getDirectJooqDbSteps().useShard(userShard).imagesSteps().getBannerImagesByBid(adId);

        BannerImagesRecord expectedBannerImage = new BannerImagesRecord();
        expectedBannerImage.setBid(adId);
        expectedBannerImage.setImageHash(wideAssociatedHash);

        assertThat(
                "найдена правильная картинка РМП",
                actualBannerImage,
                recordDiffer(expectedBannerImage).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    public void addMobileAppAdWithRegularAdImage() {
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAdImageHash(regularAssociatedHash)
                        )
        );

        BannerImagesRecord actualBannerImage =
                api.userSteps.getDirectJooqDbSteps().useShard(userShard).imagesSteps().getBannerImagesByBid(adId);

        BannerImagesRecord expectedBannerImage = new BannerImagesRecord();
        expectedBannerImage.setBid(adId);
        expectedBannerImage.setImageHash(regularAssociatedHash);

        assertThat(
                "найдена правильная картинка РМП",
                actualBannerImage,
                recordDiffer(expectedBannerImage).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }

}
