package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by proxeter on 01.03.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Description("Проверка ошибки при добавлении несуществующего изображения к РМП")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Feature(AdsFeatures.ADD)
public class AddMobileAppAdWithInvalidAdImageTest {

    private static final String LOGIN = AdsLogins.CLIENT23;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private Long campaignId;
    private String adImageHash;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, 1)[0];
    }

    @Test
    public void addWithNonExistentAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withAds(
                                new AdAddItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withMobileAppAd(
                                                new MobileAppAdAddMap()
                                                        .defaultMobileAppAd()
                                                        .withAdImageHash(RandomStringUtils.randomAlphabetic(8))
                                        )
                        ),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND))
        );
    }

    @Test
    public void addWithNotMyAdImageHash() {
        api.as(AdsLogins.CLIENT_ELSE);
        Long campaignIdElse = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupIdElse = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignIdElse);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd().withAdImageHash(adImageHash))
                                .withAdGroupId(adGroupIdElse)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)));
    }

    @Test
    public void addWithDeletedAdImageHash() {
        api.userSteps.imagesSteps().adImageDelete(adImageHash);
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd().withAdImageHash(adImageHash))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)));
    }

    @Test
    public void addWithEmptyAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd().withAdImageHash(""))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)));
    }

    @Test
    public void addWithSpaceAdImageHash() {
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd().withAdImageHash(" "))
                                .withAdGroupId(adGroupId)),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)));
    }

}
