package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by proxeter on 01.03.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Description("Проверка ошибки при добавлении маленького изображения к РМП")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Feature(AdsFeatures.ADD)
public class AddMobileAppAdWithNotWideOrRegularAdImageTest {

    private static final String LOGIN = AdsLogins.CLIENT24;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    public void addMobileAppAdWithImageAdAdImage() {
        String imageAdAdImageHash = api.userSteps.imagesStepsV5().addDefaultImageAdAdImage();
        api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap().withAds(
                    new AdAddItemMap().withAdGroupId(adGroupId).withMobileAppAd(
                        new MobileAppAdAddMap().defaultMobileAppAd().withAdImageHash(imageAdAdImageHash)
                    )
                ),
                ExpectedResult.errors(
                        new Notification(6000, Api5ErrorDetails.INVALID_AD_IMAGE_TYPE_FOR_THIS_BANNER)
                )
        );
    }

}
