package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldLengthExceeded;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.bothJavaAndPerl;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by pavryabov on 25.06.17.
 * https://st.yandex-team.ru/DIRECT-67387
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка валидации поля Title. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-65773")
@RunWith(Parameterized.class)
public class AddTitleValidationNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    MobileAppAdAddMap mobileAppAdAddMap;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public String title;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        String wordWithGreaterThanMaxLength = randomAlphabetic(MobileAppAdAddMap.MAX_WORD_IN_TITLE_LENGTH + 1);
        return Arrays.asList(new Object[][]{
                {"Добавить баннер с пустым заголовком", "",
                        bothJavaAndPerl(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(MobileAppAdAddMap.TITLE))},
                {"Добавить баннер с заголовком, который состоит из нескольких пробелов", "   ",
                        bothJavaAndPerl(5000, Api5ErrorDetails.NO_VALUE_IN_FIELD, capitalize(MobileAppAdAddMap.TITLE))},
                {"Добавить баннер с заголовком, который содержит запрещённые символы", "サムライ",
                        expect(5002,
                                Api5ErrorDetails.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD,
                                Api5ErrorDetailsJava.USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
                                capitalize(MobileAppAdAddMap.TITLE))},
                {"Добавить баннер с заголовком, в котором неправильно использована запятая", "word ,word",
                        bothJavaAndPerl(5006,
                                Api5ErrorDetails.IMPROPER_USE_OF_PUNCTUATION_MARKS_IN_THE_FIELD,
                                capitalize(MobileAppAdAddMap.TITLE))},
                {"Добавить баннер с заголовком, содержащим слово, превышающее максимальную длину",
                        wordWithGreaterThanMaxLength,
                        bothJavaAndPerl(5006, Api5ErrorDetails.FIELD_CANT_CONTAINS_WORDS_OF_LENGTH,
                                MobileAppAdAddMap.MAX_WORD_IN_TITLE_LENGTH, capitalize(MobileAppAdAddMap.TITLE),
                                wordWithGreaterThanMaxLength)},
                {"Добавить баннер с заголовком длиной " + (MobileAppAdAddMap.MAX_TITLE_LENGTH + 1),
                        generateValidTextOfLength(MobileAppAdAddMap.MAX_TITLE_LENGTH + 1),
                        fieldLengthExceeded(capitalize(MobileAppAdAddMap.TITLE), MobileAppAdAddMap.MAX_TITLE_LENGTH)},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Before
    public void initMap() {
        mobileAppAdAddMap = new MobileAppAdAddMap()
                .withText(MobileAppAdAddMap.DEFAULT_TEXT)
                .withTitle(title)
                .withAction(MobileAppAdAddMap.DEFAULT_ACTION);
    }

    @Test
    public void addWithTitle() {
        //DIRECT-41068
        api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withMobileAppAd(mobileAppAdAddMap)
                                .withAdGroupId(adGroupId)),
                expectedResult);
    }

    private static String generateValidTextOfLength(int length) {
        StringBuilder stringBuilder = new StringBuilder(randomAlphabetic(length));
        int wordLength = MobileAppAdAddMap.MAX_WORD_IN_TITLE_LENGTH;
        for (int i = wordLength; i < length; i += wordLength) {
            stringBuilder.setCharAt(i, ' ');
        }
        return stringBuilder.toString();
    }
}
