package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка независимости статуса модерации объявления с РМП от статусов других объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@Tag(TagDictionary.TRUNK)
public class MobileAppAdCheckStatusModerateAfterAddTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void getUserShard() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    private long campaignId;
    private long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    @Description("Добавить объявление в пустую кампанию")
    public void addAdToEmptyCampaign() {
        long adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @Description("Добавить объявление в кампанию, у которой есть объявление, отправленное на модерацию")
    public void addAdToCampaignWithSentBanner() {
        long moderatedId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.adsSteps().adsModerate(moderatedId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(moderatedId);
        assumeThat("объявление отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));

        long adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @Description("Добавить объявление в активную кампанию")
    public void addAdToActiveCampaign() {
        long activeAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerActive(activeAdId);

        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(activeAdId);
        assumeThat("объявление активно", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));

        long adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("объявление осталось черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }
}
