package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.cases.TextGeoMatchingWithCampLangCases;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignLanguage;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.cases.TextGeoMatchingWithCampLangCases.TextField.TEXT;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by buhter on 29.12.15.
 * https://st.yandex-team.ru/TESTIRT-8124
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка соответствия языка в Text и геотаргетинга группы с учетом выставления языка на кампанию")
@Issue("https://st.yandex-team.ru/DIRECT-49583")
@RunWith(Parameterized.class)
public class MobileAppAdTextGeoMatchingWithCampLangPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Integer shard;
    Long adGroupId;
    MobileAppAdAddMap mobileAppAdAddMap;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String text;

    @Parameterized.Parameter(2)
    public CampaignLanguage campLang;

    @Parameterized.Parameter(3)
    public Long regionId;

    @Parameterized.Parameters(name = "{0} и выставлением языка на кампанию - {2}")
    public static Collection<Object[]> data() {
        return TextGeoMatchingWithCampLangCases.getPositiveTestCases(TEXT)
                .stream()
                .map(c -> new Object[]{c.description, c.text, c.campLang, c.regionId})
                .collect(Collectors.toList());
    }

    @BeforeClass
    public static void initTest() {
        shard = api.userSteps.clientFakeSteps().getUserShard(AdsLogins.CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    public void createGroup() {
        CampOptionsRecord campOptions = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampOptionsById(campaignId);
        campOptions.setContentLang(campLang.value());
        api.userSteps.getDirectJooqDbSteps().campaignsSteps().updateCampOptions(campOptions);

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
                        .withCampaignId(campaignId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionId));
        mobileAppAdAddMap = new MobileAppAdAddMap()
                .defaultMobileAppAd()
                .withText(text);
    }

    @Test
    public void addWithTextAndCheckSave() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withMobileAppAd(mobileAppAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TEXT));
        assertThat("текст баннера сохранился верно", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem)
                        new AdGetItemMap().withId(id).withMobileAppAd(
                                new MobileAppAdGetMap()
                                        .withText(text)
                        ).getBean())));
    }
}
