package ru.yandex.autotests.direct.api.ads.add.mobileappad;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.cases.TextGeoMatchingCases;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.cases.TextGeoMatchingCases.TextField.TITLE;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 11.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.ADD)
@Description("Проверка соответствия языка в Title и геотаргетинга группы у объявления с рекламой мобильного приложения")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@RunWith(Parameterized.class)
public class MobileAppAdTitleGeoMatchingPositiveTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;
    private MobileAppAdAddMap mobileAppAdAddMap;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String title;

    @Parameterized.Parameter(2)
    public Long regionId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return TextGeoMatchingCases.getPositiveCases(TITLE)
                .stream()
                .map(c -> new Object[]{c.description, c.text, c.regionId})
                .collect(Collectors.toList());
    }

    private static Long campaignId;
    private static int shard;

    @BeforeClass
    public static void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    public void createGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(regionId));

        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);
        mobileAppAdAddMap = new MobileAppAdAddMap()
                .defaultMobileAppAd()
                .withText(MobileAppAdAddMap.DEFAULT_TEXT)
                .withTitle(title)
                .withTrackingUrl(MobileAppAdAddMap.DEFAULT_TRACKING_URL);
    }

    @Test
    public void addWithTitleAndCheckSave() {
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withMobileAppAd(mobileAppAdAddMap)
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        Long id = response.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(id))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TITLE));
        assertThat("текст баннера сохранился верно", getResponse.getAds(), beanEquivalent(Arrays.asList(
                (AdGetItem) new AdGetItemMap()
                        .withId(id)
                        .withMobileAppAd(new MobileAppAdGetMap()
                                .withTitle(title)).getBean())));
    }
}
